/*+ MetaParser.h
 *
 ******************************************************************************
 *
 *                        Trimble Navigation Limited
 *                           645 North Mary Avenue
 *                              P.O. Box 3642
 *                         Sunnyvale, CA 94088-3642
 *
 ******************************************************************************
 *
 *    Copyright  2005 Trimble Navigation Ltd.
 *    All Rights Reserved
 *
 ******************************************************************************
 *
 * Description:
 *    This file defines the CMetaParser class.
 *            
 * Revision History:
 *    01-11-2007    Jacob Norda
 *                  Written
 *
 * Notes:
 *
-*/

#ifndef META_PARSER_H
#define META_PARSER_H

/*---------------------------------------------------------------------------*\
 |                         I N C L U D E   F I L E S
\*---------------------------------------------------------------------------*/
#include "ParserDefinitions.h"
#include "TsipParser.h"
#include "NmeaParser.h"


/*---------------------------------------------------------------------------*\
 |                  C O N S T A N T S   A N D   M A C R O S
\*---------------------------------------------------------------------------*/
#define __MAX(a,b)  ( (a) > (b) ? (a) : (b) )
#define MAX_PKT_LEN (__MAX(MAX_TSIP_PKT_LEN, MAX_NMEA_PKT_LEN))


/*---------------------------------------------------------------------------*\
 |             F O R W A R D   C L A S S   D E C L A R A T I O N S
\*---------------------------------------------------------------------------*/
class CCommPort;


/*---------------------------------------------------------------------------*\
 |                      C L A S S   D E F I N I T I O N
\*---------------------------------------------------------------------------*/
class CMetaParser
{
public: //==== P U B L I C   M E T H O D S ===================================/

	CMetaParser(void) {};
	~CMetaParser(void) {};

    CString ReceiveAndParsePkt (CCommPort* pPort, unsigned char ucPkt[], int *pPktLen);
	void SendNmeaPkt(CCommPort* pPort); 


private: //==== P R I V A T E   M E M B E R   V A R I A B L E S ==============/

	CTsipParser m_TsipParser; 
	CNmeaParser m_NmeaParser; 

};


#endif